/*
 * Decompiled with CFR 0.152.
 */
package petter.eclipse.documentspy;

import java.math.BigDecimal;
import java.sql.Time;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import petter.eclipse.documentspy.ITableDecorator;

public class TableDecorator
implements ITableDecorator {
    private DateFormat df = DateFormat.getDateInstance(3);
    private DateFormat tf = DateFormat.getTimeInstance();
    private NumberFormat nf = NumberFormat.getInstance();

    public TableDecorator() {
        this.nf.setGroupingUsed(true);
        this.nf.setMinimumFractionDigits(2);
    }

    @Override
    public Color getBackgroundColor(int spalte, List<Object> obj) {
        return null;
    }

    @Override
    public Font getFont(int spalte, List<Object> obj) {
        return null;
    }

    @Override
    public Color getForegroundColor(int spalte, List<Object> obj) {
        return null;
    }

    @Override
    public Image getImage(int spalte, List<Object> obj) {
        return null;
    }

    @Override
    public String getText(int spalte, List<Object> obj) {
        Object o = obj.get(spalte);
        if (o != null) {
            if (o instanceof Time) {
                return this.tf.format((Time)o);
            }
            if (o instanceof Date) {
                return this.df.format((Date)o);
            }
            if (o instanceof BigDecimal && ((BigDecimal)o).scale() == 2) {
                return this.nf.format((BigDecimal)o);
            }
            return o.toString();
        }
        return "";
    }

    @Override
    public String getOpenOfficeFormula(int spalte, List<Object> obj) {
        if (obj.get(spalte) != null) {
            if (obj.get(spalte) instanceof Date) {
                Calendar cal = Calendar.getInstance();
                cal.setTime((Date)obj.get(spalte));
                return "=DATE(" + new Integer(cal.get(1)).toString() + ";" + new Integer(cal.get(2) + 1).toString() + ";" + new Integer(cal.get(5)).toString() + ")";
            }
            return obj.get(spalte).toString();
        }
        return "";
    }

    @Override
    public int getColumnAlignment(int spalte) {
        return 16384;
    }
}

