/*
 * Decompiled with CFR 0.152.
 */
package petter.eclipse.documentspy;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import petter.eclipse.documentspy.ITableDataAdvancedFilter;

public class TableData {
    private String tableDataType;
    public static final int DOWN = 1024;
    public static final int UP = 128;
    private boolean summenZeile;
    private ITableDataAdvancedFilter filter;
    private int sortedColumn;
    private int sortDirection;
    private List<List<Object>> zeilen = new ArrayList<List<Object>>();
    private List<List<Object>> zeilenGefiltert;
    private boolean ready;

    public TableData() {
        this.ready = true;
        this.tableDataType = null;
    }

    public TableData(String spalte1, String spalte2) {
        List<String> sp1 = Arrays.asList(spalte1.split(","));
        List<String> sp2 = Arrays.asList(spalte2.split(","));
        int i = 0;
        while (i < sp1.size()) {
            this.setObject(i, 0, sp1.get(i));
            this.setObject(i, 1, sp2.get(i));
            ++i;
        }
        this.setReady(true);
        this.tableDataType = null;
    }

    public TableData(String spalte1, String spalte2, String spalte3) {
        List<String> sp1 = Arrays.asList(spalte1.split(","));
        List<String> sp2 = Arrays.asList(spalte2.split(","));
        List<String> sp3 = Arrays.asList(spalte3.split(","));
        int i = 0;
        while (i < sp1.size()) {
            this.setObject(i, 0, sp1.get(i));
            this.setObject(i, 1, sp2.get(i));
            this.setObject(i, 2, sp3.get(i));
            ++i;
        }
        this.setReady(true);
        this.tableDataType = null;
    }

    public TableData(List spalte1, List spalte2) {
        int i = 0;
        while (i < spalte1.size()) {
            this.setObject(i, 0, spalte1.get(i));
            this.setObject(i, 1, spalte2.get(i));
            ++i;
        }
        this.setReady(true);
        this.tableDataType = null;
    }

    public TableData(TableData tableData) {
        int i = 0;
        while (i < tableData.size()) {
            this.setRow(i, new ArrayList<Object>(tableData.getRow(i)));
            ++i;
        }
        this.setReady(true);
        this.tableDataType = null;
    }

    public TableData(Map<? extends Object, ? extends Object> map) {
        this();
        int row = 0;
        for (Object object : map.keySet()) {
            this.setObject(row, 0, object);
            this.setObject(row, 1, map.get(object));
            ++row;
        }
    }

    public List<Object> getRow(int index) {
        if (this.filter == null) {
            return this.zeilen.get(index);
        }
        return this.zeilenGefiltert.get(index);
    }

    public Object getObject(int row, int column) {
        try {
            if (this.filter == null) {
                return this.zeilen.get(row).get(column);
            }
            return this.zeilenGefiltert.get(row).get(column);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public void setObject(int row, int column, Object obj) {
        int i = this.zeilen.size();
        while (i <= row) {
            this.zeilen.add(new ArrayList());
            ++i;
        }
        List<Object> zeile = this.zeilen.get(row);
        int i2 = zeile.size();
        while (i2 <= column) {
            zeile.add(null);
            ++i2;
        }
        zeile.set(column, obj);
    }

    public int indexOf(int column, Object obj) {
        if (this.filter == null) {
            int i = 0;
            while (i < this.zeilen.size()) {
                if (this.getObject(i, column).equals(obj)) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.zeilenGefiltert.size()) {
                if (this.getObject(i, column) != null && this.getObject(i, column).equals(obj)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public int size() {
        if (this.filter == null) {
            return this.zeilen.size();
        }
        return this.zeilenGefiltert.size();
    }

    public int getColumnCount() {
        if (this.size() == 0) {
            return 0;
        }
        return this.zeilen.get(0).size();
    }

    public void sort(int column, int sortDir) {
        this.sortedColumn = column;
        this.sortDirection = sortDir;
        List<List<Object>> liste = null;
        liste = this.filter == null ? this.zeilen : this.zeilenGefiltert;
        List<Object> summenZeile = null;
        if (this.isSummenZeile()) {
            summenZeile = liste.get(liste.size() - 1);
            liste.remove(liste.size() - 1);
        }
        Collections.sort(liste, new Comparator<List<Object>>(){

            @Override
            public int compare(List<Object> o1, List<Object> o2) {
                Comparable c1 = null;
                Comparable c2 = null;
                if (o1.get(TableData.this.sortedColumn) instanceof Comparable) {
                    c1 = (Comparable)o1.get(TableData.this.sortedColumn);
                } else if (o1.get(TableData.this.sortedColumn) != null) {
                    c1 = (Comparable)((Object)o1.get(TableData.this.sortedColumn).toString());
                }
                if (o2.get(TableData.this.sortedColumn) instanceof Comparable) {
                    c2 = (Comparable)o2.get(TableData.this.sortedColumn);
                } else if (o2.get(TableData.this.sortedColumn) != null) {
                    c2 = (Comparable)((Object)o2.get(TableData.this.sortedColumn).toString());
                }
                if (TableData.this.sortDirection == 128) {
                    if (c1 == null && c2 == null) {
                        return 0;
                    }
                    if (c1 == null) {
                        return -1;
                    }
                    if (c2 == null) {
                        return 1;
                    }
                } else {
                    if (c1 == null && c2 == null) {
                        return 0;
                    }
                    if (c1 == null) {
                        return 1;
                    }
                    if (c2 == null) {
                        return -1;
                    }
                }
                if (!c1.getClass().equals(c2.getClass())) {
                    c1 = (Comparable)((Object)c1.toString());
                    c2 = (Comparable)((Object)c2.toString());
                }
                if (c1.getClass().equals(String.class) && TableData.this.isNumeric(c1.toString()) && c2.getClass().equals(String.class) && TableData.this.isNumeric(c2.toString())) {
                    c1 = new BigDecimal(c1.toString());
                    c2 = new BigDecimal(c2.toString());
                }
                if (TableData.this.sortDirection == 128) {
                    return this.prepairForCompare(c1).compareTo(this.prepairForCompare(c2));
                }
                return this.prepairForCompare(c2).compareTo(this.prepairForCompare(c1));
            }

            private Comparable prepairForCompare(Comparable c) {
                if (c instanceof String) {
                    return TableData.this.fastReplaceSonderzeichen((String)((Object)c));
                }
                return c;
            }
        });
        if (this.isSummenZeile()) {
            liste.add(summenZeile);
        }
    }

    public void setReady(boolean ready) {
        this.ready = ready;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void setTableDataType(String tableDataType) {
        this.tableDataType = tableDataType;
    }

    public String getTableDataType() {
        return this.tableDataType;
    }

    public boolean waitTillReady(int time) {
        int i = 0;
        while (i < time * 10) {
            if (this.isReady()) {
                return true;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
            ++i;
        }
        return false;
    }

    public Object[] getRows() {
        if (this.filter == null) {
            return this.zeilen.toArray();
        }
        return this.zeilenGefiltert.toArray();
    }

    public void deleteRow(int index) {
        this.zeilen.remove(index);
    }

    public int getSortedColumn() {
        return this.sortedColumn;
    }

    public int getSortDirection() {
        return this.sortDirection;
    }

    public void setRow(int index, List zeile) {
        if (index < this.zeilen.size()) {
            this.zeilen.set(index, zeile);
            return;
        }
        int i = this.zeilen.size();
        while (i <= index - 1) {
            this.zeilen.add(new ArrayList());
            ++i;
        }
        this.zeilen.add(zeile);
    }

    public void setFilter(String filter) {
        if (filter == null) {
            this.setFilterList(new ArrayList<String>());
            return;
        }
        ArrayList<String> temp = new ArrayList<String>();
        temp.add(filter);
        this.setFilterList(temp);
    }

    public void setFilterList(final List<String> filterStrings) {
        if (filterStrings == null || filterStrings.size() == 0) {
            this.setAdvancedFilter(null);
            return;
        }
        this.setAdvancedFilter(new ITableDataAdvancedFilter(){

            @Override
            public boolean isFiltered(List<Object> zeile) {
                for (String filterEntry : filterStrings) {
                    for (Object obj : zeile) {
                        if (obj == null || !obj.toString().toLowerCase().contains(filterEntry.toLowerCase())) continue;
                        return true;
                    }
                }
                return false;
            }
        });
    }

    public void setAdvancedFilter(ITableDataAdvancedFilter filter) {
        this.filter = filter;
        if (filter != null) {
            this.zeilenGefiltert = new ArrayList<List<Object>>();
            for (List<Object> zeile : this.zeilen) {
                if (!filter.isFiltered(zeile)) continue;
                this.zeilenGefiltert.add(zeile);
            }
        } else {
            this.zeilenGefiltert = null;
        }
    }

    public void initialize(int sizeX, int sizeY, Object obj) {
        int i = 0;
        while (i < sizeY) {
            int i2 = 0;
            while (i2 < sizeX) {
                this.setObject(i, i2, obj);
                ++i2;
            }
            ++i;
        }
    }

    public boolean isSummenZeile() {
        return this.summenZeile;
    }

    public void setSummenZeile(boolean summenZeile) {
        this.summenZeile = summenZeile;
    }

    private String fastReplaceSonderzeichen(String string) {
        char[] zielCharArray = null;
        char[] charArray = string.toCharArray();
        int length = charArray.length;
        int pos = 0;
        while (pos < length) {
            int i;
            if ((charArray[pos] == '\u00e4' || charArray[pos] == '\u00c4') && zielCharArray == null) {
                zielCharArray = new char[string.length()];
                i = 0;
                while (i < pos) {
                    zielCharArray[i] = charArray[i];
                    ++i;
                }
                zielCharArray[pos] = 97;
            } else if ((charArray[pos] == '\u00f6' || charArray[pos] == '\u00d6') && zielCharArray == null) {
                zielCharArray = new char[string.length()];
                i = 0;
                while (i < pos) {
                    zielCharArray[i] = charArray[i];
                    ++i;
                }
                zielCharArray[pos] = 111;
            } else if ((charArray[pos] == '\u00fc' || charArray[pos] == '\u00dc') && zielCharArray == null) {
                zielCharArray = new char[string.length()];
                i = 0;
                while (i < pos) {
                    zielCharArray[i] = charArray[i];
                    ++i;
                }
                zielCharArray[pos] = 117;
            } else if (charArray[pos] == '\u00df' && zielCharArray == null) {
                zielCharArray = new char[string.length()];
                i = 0;
                while (i < pos) {
                    zielCharArray[i] = charArray[i];
                    ++i;
                }
                zielCharArray[pos] = 115;
            } else if (zielCharArray != null) {
                zielCharArray[pos] = charArray[pos];
            }
            ++pos;
        }
        if (zielCharArray == null) {
            return string;
        }
        return new String(zielCharArray);
    }

    private boolean isNumeric(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if ((c < '0' || c > '9') & c != '.') {
                return false;
            }
            ++n2;
        }
        try {
            new BigDecimal(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }
}

