/*
 * Decompiled with CFR 0.152.
 */
package petter.eclipse.documentspy;

import com.ibm.notes.java.api.util.NotesSessionJob;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import lotus.domino.Database;
import lotus.domino.Document;
import lotus.domino.Item;
import lotus.domino.NotesException;
import lotus.domino.Session;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.part.ViewPart;
import petter.eclipse.documentspy.NItem;
import petter.eclipse.documentspy.SimpleTable;
import petter.eclipse.documentspy.TableData;
import petter.eclipse.documentspy.TableDecorator;

public class SnapshotViewer
extends ViewPart {
    private SimpleTable table;
    private List<String> spaltenTitel;
    private TableData data;
    private String replicaID;
    private String unID;
    private String server;
    private Composite comp;
    private IAction delta;
    private int deltaCol = 1;
    private final Color red = new Color((Device)Display.getDefault(), 255, 100, 100);
    private final Color blue = new Color((Device)Display.getDefault(), 100, 100, 255);
    private final Color green = new Color((Device)Display.getDefault(), 100, 255, 100);
    public static final String id = "petter.eclipse.snapshotviewer";

    public void dispose() {
        super.dispose();
        this.red.dispose();
        this.green.dispose();
        this.blue.dispose();
    }

    public void createPartControl(Composite parent) {
        this.comp = parent;
        this.createActions();
    }

    private void createActions() {
        IToolBarManager toolbar = this.getViewSite().getActionBars().getToolBarManager();
        this.delta = new Action(){

            public void run() {
                SnapshotViewer.this.delta.setEnabled(false);
                NotesSessionJob job = new NotesSessionJob("Deltavalues hinzuf\u00fcgen"){

                    protected IStatus runInNotesThread(Session session, IProgressMonitor monitor) throws NotesException {
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        Database db = session.getDatabase(null, null);
                        db.openByReplicaID(SnapshotViewer.this.server, SnapshotViewer.this.replicaID);
                        Document doc = db.getDocumentByUNID(SnapshotViewer.this.unID);
                        ArrayList<NItem> items = new ArrayList<NItem>();
                        items.add(new NItem("#Notes-URL", doc.getNotesURL(), SnapshotViewer.this.server, SnapshotViewer.this.replicaID, SnapshotViewer.this.unID));
                        items.add(new NItem("#Note-ID", doc.getNoteID(), SnapshotViewer.this.server, SnapshotViewer.this.replicaID, SnapshotViewer.this.unID));
                        items.add(new NItem("#Note-UNID", doc.getUniversalID(), SnapshotViewer.this.server, SnapshotViewer.this.replicaID, SnapshotViewer.this.unID));
                        if (doc.isProfile()) {
                            items.add(new NItem("#IsProfile", "True", SnapshotViewer.this.server, SnapshotViewer.this.replicaID, SnapshotViewer.this.unID));
                            items.add(new NItem("#Name of Profile", doc.getNameOfProfile(), SnapshotViewer.this.server, SnapshotViewer.this.replicaID, SnapshotViewer.this.unID));
                            items.add(new NItem("#Key of Profile", doc.getKey(), SnapshotViewer.this.server, SnapshotViewer.this.replicaID, SnapshotViewer.this.unID));
                        }
                        for (Object obj : doc.getItems()) {
                            Item item = (Item)obj;
                            try {
                                Vector values = item.getValues();
                                if (values == null || values.size() == 0) {
                                    items.add(new NItem(item.getName(), null, item.getType(), SnapshotViewer.this.server, SnapshotViewer.this.replicaID, SnapshotViewer.this.unID));
                                    continue;
                                }
                                items.add(new NItem(item.getName(), values.toArray(), item.getType(), SnapshotViewer.this.server, SnapshotViewer.this.replicaID, SnapshotViewer.this.unID));
                            }
                            catch (NotesException e) {
                                e.printStackTrace();
                                System.out.println("Item: " + item.getName());
                            }
                        }
                        for (NItem item : items) {
                            int pos = SnapshotViewer.this.data.indexOf(1, item.getName());
                            if (pos == -1) {
                                pos = SnapshotViewer.this.data.size();
                            }
                            SnapshotViewer.this.data.setObject(pos, 0, item);
                            SnapshotViewer.this.data.setObject(pos, 1, item.getName());
                            SnapshotViewer.this.data.setObject(pos, 2, item.getFormatedType());
                            SnapshotViewer.this.data.setObject(pos, 3 + SnapshotViewer.this.deltaCol, item.getFormatedValue());
                        }
                        SnapshotViewer snapshotViewer = SnapshotViewer.this;
                        snapshotViewer.deltaCol = snapshotViewer.deltaCol + 1;
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                SnapshotViewer.this.delta.setEnabled(true);
                                SnapshotViewer.this.spaltenTitel.add(DateFormat.getDateTimeInstance().format(new Date()));
                                SnapshotViewer.this.updateTable();
                            }
                        });
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        };
        this.delta.setText("Add Delta Column");
        this.delta.setText("Add a new column with the current values and compare them with the last update");
        this.delta.setImageDescriptor(ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"/petter/eclipse/documentspy/images/delta.png"));
        toolbar.add(this.delta);
    }

    public void setFocus() {
    }

    public void initialize(TableData data, String server, String replicaID, String unID) {
        this.deltaCol = 1;
        this.data = data;
        this.replicaID = replicaID;
        this.unID = unID;
        try {
            this.server = URLDecoder.decode(server, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        this.spaltenTitel = new ArrayList<String>(Arrays.asList("#HIDE", "Item", "Type", "Basevalue"));
        this.updateTable();
    }

    private void updateTable() {
        if (this.table != null && !this.table.isDisposed()) {
            this.table.dispose();
        }
        this.table = new SimpleTable(this.comp, 65536, 0, this.spaltenTitel.toArray(new String[0]), this.data, new TableDecorator(){

            @Override
            public Color getBackgroundColor(int spalte, List<Object> obj) {
                if (spalte > 3) {
                    String wertAlt = obj.get(spalte - 1) != null ? obj.get(spalte - 1).toString() : "";
                    String wertNeu = obj.get(spalte) != null ? obj.get(spalte).toString() : "";
                    if (wertAlt.equals("") && !wertNeu.equals("")) {
                        return SnapshotViewer.this.green;
                    }
                    if (!wertAlt.equals("") && wertNeu.equals("")) {
                        return SnapshotViewer.this.blue;
                    }
                    if (!wertAlt.equals(wertNeu)) {
                        return SnapshotViewer.this.red;
                    }
                }
                return super.getBackgroundColor(spalte, obj);
            }
        });
        this.comp.layout();
    }
}

