/*
 * Decompiled with CFR 0.152.
 */
package petter.eclipse.documentspy;

import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import petter.eclipse.documentspy.ITableDecorator;
import petter.eclipse.documentspy.TableData;
import petter.eclipse.documentspy.TableDecorator;

public class SimpleTable
extends Composite {
    protected int style;
    protected Table table;
    protected int internalKeySpalte;
    protected String[] internalSpaltenTitel;
    protected TableData internalTableData;
    private ITableDecorator tableDecorator;
    private List<Object> currentSelection;
    private HashMap<SelectionListener, SelectionListener> selectionListener;
    private volatile boolean sorted;
    private volatile int sortedColumn;
    private volatile int sortDirection;
    private volatile boolean isSized;
    private volatile boolean lastColumnResize;
    private String columnSizeConfig;

    public SimpleTable(Composite parent, int style, int keySpalte, String[] spaltenTitel, TableData tableData) {
        this(parent, style, keySpalte, spaltenTitel, tableData, new TableDecorator());
    }

    public SimpleTable(Composite parent, int style, int keySpalte, String[] spaltenTitel, TableData tableData, ITableDecorator tableDecorator) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        this.selectionListener = new HashMap();
        this.style = style;
        this.internalKeySpalte = keySpalte;
        this.internalSpaltenTitel = spaltenTitel;
        this.internalTableData = tableData;
        this.table = new Table((Composite)this, 0x10000000 | style);
        this.table.setToolTipText("");
        this.table.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                TableItem item = (TableItem)event.item;
                String text = item.getText(event.index);
                if (text == null || text.length() < 255) {
                    return;
                }
                text = text.replaceAll("\\n", " ");
                text = text.replaceAll("\\r", " ");
                event.gc.setFont(item.getFont());
                event.gc.setForeground(item.getForeground());
                Point size = event.gc.textExtent(text);
                event.width = size.x + 6;
                if (item.getImage(event.index) != null) {
                    event.width = event.width + item.getImage((int)event.index).getBounds().width + 3;
                }
                event.height = Math.max(event.height, size.y + 3);
            }
        });
        this.table.addListener(40, new Listener(){

            public void handleEvent(Event event) {
                TableItem item = (TableItem)event.item;
                String text = item.getText(event.index);
                if (text == null || text.length() < 255) {
                    return;
                }
                event.detail &= 0xFFFFFFEF;
            }
        });
        this.table.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                TableItem item = (TableItem)event.item;
                String text = item.getText(event.index);
                if (text == null || text.length() < 255) {
                    return;
                }
                text = text.replaceAll("\\n", " ");
                text = text.replaceAll("\\r", " ");
                event.gc.setFont(item.getFont());
                event.gc.setForeground(item.getForeground());
                int yOffset = 0;
                int xOffset = event.x + 3;
                if (item.getImage(event.index) != null) {
                    event.gc.drawImage(item.getImage(event.index), event.x + 3, event.y + yOffset);
                    xOffset = xOffset + item.getImage((int)event.index).getBounds().width + 3;
                }
                event.gc.drawText(text, xOffset, event.y + yOffset, true);
            }
        });
        Listener tableListener = new Listener(){
            Shell tip = null;
            Label label = null;
            Display display;
            {
                this.display = SimpleTable.this.table.getShell().getDisplay();
            }

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: 
                    case 5: 
                    case 12: {
                        if (this.tip == null) break;
                        this.tip.dispose();
                        this.tip = null;
                        this.label = null;
                        break;
                    }
                    case 32: {
                        Point pt = new Point(event.x, event.y);
                        TableItem item = SimpleTable.this.table.getItem(pt);
                        if (item == null) break;
                        int index = 0;
                        int i = 0;
                        while (i < SimpleTable.this.table.getColumnCount()) {
                            Rectangle rect = item.getBounds(i);
                            if (rect.contains(pt)) {
                                index = i;
                                break;
                            }
                            ++i;
                        }
                        String text = item.getText(index);
                        text = text.replaceAll("\\n", " ");
                        text = text.replaceAll("\\r", " ");
                        GC gc = new GC((Drawable)SimpleTable.this.table.getShell());
                        gc.setFont(item.getFont(index));
                        gc.setForeground(item.getForeground(index));
                        Point size = gc.textExtent(text);
                        gc.dispose();
                        if (size.x + 6 < item.getTextBounds((int)index).width) {
                            return;
                        }
                        if (this.tip != null && !this.tip.isDisposed()) {
                            this.tip.dispose();
                        }
                        this.tip = new Shell(SimpleTable.this.table.getShell(), 16388);
                        this.tip.setLayout((Layout)new FillLayout());
                        this.label = new Label((Composite)this.tip, 64);
                        this.label.setForeground(this.display.getSystemColor(28));
                        this.label.setBackground(this.display.getSystemColor(29));
                        this.label.setData("_TABLEITEM", (Object)item);
                        Listener labelListener = new Listener(){
                            private boolean doubleClick;

                            public void handleEvent(Event event) {
                                Label label = (Label)event.widget;
                                Shell shell = label.getShell();
                                if (event.type == 8) {
                                    this.doubleClick = true;
                                    Event e = new Event();
                                    e.item = (TableItem)label.getData("_TABLEITEM");
                                    (this).SimpleTable.this.table.setSelection((TableItem)e.item);
                                    (this).SimpleTable.this.table.notifyListeners(14, e);
                                    shell.dispose();
                                    (this).SimpleTable.this.table.setFocus();
                                }
                            }
                        };
                        this.label.addListener(8, labelListener);
                        Rectangle rect = item.getBounds(index);
                        Point pt2 = SimpleTable.this.table.toDisplay(rect.x, rect.y);
                        this.label.setText(item.getText(index));
                        Point labelSize = this.label.computeSize(-1, -1);
                        if (labelSize.x >= this.display.getPrimaryMonitor().getClientArea().width - pt2.x) {
                            labelSize = this.label.computeSize(this.display.getPrimaryMonitor().getClientArea().width - pt2.x - 15, -1);
                        }
                        if (pt2.x < 0) {
                            this.tip.setBounds(0, pt2.y, labelSize.x + 10, labelSize.y);
                        } else {
                            this.tip.setBounds(pt2.x, pt2.y, labelSize.x + 10, labelSize.y);
                        }
                        this.tip.setVisible(true);
                    }
                }
            }
        };
        this.table.addListener(12, tableListener);
        this.table.addListener(1, tableListener);
        this.table.addListener(5, tableListener);
        this.table.addListener(32, tableListener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent paramDisposeEvent) {
                SimpleTable.this.columnSizeConfig = SimpleTable.this.getColumnSizeConfig();
            }
        });
        this.table.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent arg0) {
                SimpleTable.this.updateColumsSize(true);
                if (SimpleTable.this.lastColumnResize && SimpleTable.this.internalTableData != null & SimpleTable.this.internalTableData.size() > 0) {
                    SimpleTable.this.lastColumnResize = false;
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            int sumColumnWidth = 0;
                            int i = 0;
                            while (i < (this).SimpleTable.this.internalSpaltenTitel.length) {
                                if (!(this).SimpleTable.this.internalSpaltenTitel[i].equals("#HIDE")) {
                                    if (i + 1 == (this).SimpleTable.this.internalSpaltenTitel.length && sumColumnWidth + (this).SimpleTable.this.table.getColumn(i).getWidth() != (this).SimpleTable.this.table.getSize().x - ((this).SimpleTable.this.table.getVerticalBar().isVisible() ? (this).SimpleTable.this.table.getVerticalBar().getSize().x : 0)) {
                                        (this).SimpleTable.this.table.getColumn(i).pack();
                                        if (sumColumnWidth + (this).SimpleTable.this.table.getColumn(i).getWidth() != (this).SimpleTable.this.table.getSize().x - ((this).SimpleTable.this.table.getVerticalBar().isVisible() ? (this).SimpleTable.this.table.getVerticalBar().getSize().x : 0)) {
                                            (this).SimpleTable.this.table.getColumn(i).setWidth((this).SimpleTable.this.table.getSize().x - sumColumnWidth - ((this).SimpleTable.this.table.getVerticalBar().isVisible() ? (this).SimpleTable.this.table.getVerticalBar().getSize().x : 0) - 2 * (this).SimpleTable.this.table.getBorderWidth());
                                        }
                                    }
                                    sumColumnWidth += (this).SimpleTable.this.table.getColumn(i).getWidth();
                                }
                                ++i;
                            }
                        }
                    });
                }
            }
        });
        this.tableDecorator = tableDecorator == null ? new TableDecorator() : tableDecorator;
        this.table.addListener(36, new Listener(){

            public void handleEvent(Event event) {
                TableItem item = (TableItem)event.item;
                SimpleTable.this.fillTableItem(item);
            }
        });
        this.setBackground(this.table.getBackground());
        this.setForeground(this.table.getForeground());
        this.setFont(this.table.getFont());
        this.table.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                SimpleTable.this.onMouseDown(e);
            }
        });
        this.table.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                SimpleTable.this.onSelection(e);
            }
        });
        this.table.addListener(14, new Listener(){

            public void handleEvent(Event e) {
                SimpleTable.this.onDefaultSelection(e);
            }
        });
        this.addListener(12, new Listener(){

            public void handleEvent(Event e) {
                SimpleTable.this.onDispose();
            }
        });
        this.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                SimpleTable.this.onResize();
            }
        });
        this.addListener(15, new Listener(){

            public void handleEvent(Event e) {
                SimpleTable.this.onFocusIn();
            }
        });
        int i = 0;
        while (i < spaltenTitel.length) {
            final int columnIndex = i;
            final SimpleTable simpleTable = this;
            int columnStyle = this.tableDecorator.getColumnAlignment(columnIndex);
            TableColumn column = new TableColumn(this.table, columnStyle);
            column.setText(spaltenTitel[i]);
            column.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void widgetSelected(SelectionEvent e) {
                    if (SimpleTable.this.table.getSortColumn() == SimpleTable.this.table.getColumn(columnIndex)) {
                        if (SimpleTable.this.table.getSortDirection() == 128) {
                            SimpleTable.this.table.setSortDirection(1024);
                            TableData tableData = SimpleTable.this.internalTableData;
                            synchronized (tableData) {
                                SimpleTable.this.updateSelection();
                                simpleTable.getTableData().sort(columnIndex, 1024);
                                SimpleTable.this.sortedColumn = columnIndex;
                                SimpleTable.this.sortDirection = 1024;
                                SimpleTable.this.sorted = true;
                            }
                        } else {
                            SimpleTable.this.table.setSortDirection(128);
                            TableData tableData = SimpleTable.this.internalTableData;
                            synchronized (tableData) {
                                SimpleTable.this.updateSelection();
                                simpleTable.getTableData().sort(columnIndex, 128);
                                SimpleTable.this.sortedColumn = columnIndex;
                                SimpleTable.this.sortDirection = 128;
                                SimpleTable.this.sorted = true;
                            }
                        }
                    } else {
                        SimpleTable.this.table.setSortDirection(128);
                        SimpleTable.this.table.setSortColumn(SimpleTable.this.table.getColumn(columnIndex));
                        TableData tableData = SimpleTable.this.internalTableData;
                        synchronized (tableData) {
                            SimpleTable.this.updateSelection();
                            simpleTable.getTableData().sort(columnIndex, 128);
                            SimpleTable.this.sortedColumn = columnIndex;
                            SimpleTable.this.sortDirection = 128;
                            SimpleTable.this.sorted = true;
                        }
                    }
                    SimpleTable.this.updateTable();
                    SimpleTable.this.setSelection();
                }
            });
            ++i;
        }
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                if (4 == event.detail) {
                    event.doit = false;
                }
            }
        });
        this.updateTable();
    }

    public TableData getTableData() {
        return this.internalTableData;
    }

    public void setBackgroundMode(int mode) {
        super.setBackgroundMode(mode);
        this.table.setBackgroundMode(mode);
    }

    public void setBackground(Color arg0) {
        super.setBackground(arg0);
        this.table.setBackground(arg0);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.table.setFont(font);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.table.setForeground(color);
    }

    public void select(int row) {
        this.table.select(row);
    }

    protected void onSelection(Event e) {
        SelectionListener[] selectionListenerArray = this.selectionListener.values().toArray(new SelectionListener[0]);
        int n = selectionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            SelectionListener listener = selectionListenerArray[n2];
            listener.widgetSelected(new SelectionEvent(e));
            ++n2;
        }
    }

    protected void onDefaultSelection(Event e) {
        SelectionListener[] selectionListenerArray = this.selectionListener.values().toArray(new SelectionListener[0]);
        int n = selectionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            SelectionListener listener = selectionListenerArray[n2];
            listener.widgetDefaultSelected(new SelectionEvent(e));
            ++n2;
        }
    }

    protected void onMouseDown(Event e) {
    }

    void onFocusIn() {
        if (!this.table.isDisposed()) {
            this.table.setFocus();
        }
    }

    public void addKeyListener(KeyListener arg0) {
        this.table.addKeyListener(arg0);
    }

    protected void onResize() {
        Rectangle area = this.getClientArea();
        this.table.setBounds(0, 0, area.width, area.height);
    }

    protected void onDispose() {
        this.table.dispose();
    }

    public Point computeSize(int wHint, int hHint) {
        Point size = this.table.computeSize(wHint, hHint, true);
        size.x += this.table.getVerticalBar().getSize().x;
        return size;
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        return this.table.computeTrim(x, y, width, height);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.selectionListener.put(listener, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.selectionListener.remove(listener);
    }

    private void setSelection() {
        this.table.deselectAll();
        if (this.currentSelection == null) {
            return;
        }
        int i = 0;
        while (i < this.currentSelection.size()) {
            int index = this.internalTableData.indexOf(this.internalKeySpalte, this.currentSelection.get(i));
            if (index != -1) {
                this.table.select(index);
            }
            ++i;
        }
    }

    private void updateSelection() {
        this.currentSelection = new ArrayList<Object>();
        int[] nArray = this.table.getSelectionIndices();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            this.currentSelection.add(this.internalTableData.getObject(i, this.internalKeySpalte));
            ++n2;
        }
    }

    private void updateTable() {
        this.table.setItemCount(0);
        this.table.removeAll();
        if (this.internalTableData != null) {
            this.table.setItemCount(this.internalTableData.size());
            this.lastColumnResize = true;
        }
        this.updateColumsSize(false);
    }

    public void setSelection(List currentSelection) {
        this.currentSelection = currentSelection;
        this.setSelection();
    }

    public List getSelection() {
        this.updateSelection();
        return this.currentSelection;
    }

    public void setTableDecorator(ITableDecorator tableDecorator) {
        this.tableDecorator = tableDecorator;
        this.updateTable();
    }

    public void setTableData(TableData data) {
        this.internalTableData = data;
        if (this.isSorted()) {
            this.sort(this.getSortColumn(), this.getSortDirection(), false);
        } else {
            this.updateTable();
        }
        this.select(0);
    }

    public int[] getSelectionIndices() {
        return this.table.getSelectionIndices();
    }

    private void fillTableItem(TableItem item) {
        int tableIndex = this.table.indexOf(item);
        int i1 = 0;
        while (i1 < this.internalSpaltenTitel.length) {
            List<Object> row = this.internalTableData.getRow(tableIndex);
            try {
                Font font;
                Color forgroundColor;
                item.setText(i1, this.tableDecorator.getText(i1, row));
                item.setImage(i1, this.tableDecorator.getImage(i1, row));
                Color backgroundColor = this.tableDecorator.getBackgroundColor(i1, row);
                if (backgroundColor != null) {
                    item.setBackground(i1, backgroundColor);
                }
                if ((forgroundColor = this.tableDecorator.getForegroundColor(i1, row)) != null) {
                    item.setForeground(i1, forgroundColor);
                }
                if ((font = this.tableDecorator.getFont(i1, row)) != null) {
                    item.setFont(i1, font);
                }
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
            }
            ++i1;
        }
    }

    public int getSortColumn() {
        return this.sortedColumn;
    }

    public int getSortDirection() {
        return this.sortDirection;
    }

    public void sort(int sortedColumn, int sortDirection) {
        this.sort(sortedColumn, sortDirection, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sort(int sortedColumn, int sortDirection, boolean selection) {
        this.sortedColumn = sortedColumn;
        this.sortDirection = sortDirection;
        this.sorted = true;
        if (this.getTableData() == null) {
            return;
        }
        TableData tableData = this.internalTableData;
        synchronized (tableData) {
            if (selection) {
                this.updateSelection();
            }
            this.getTableData().sort(sortedColumn, sortDirection);
            this.table.setSortColumn(this.table.getColumn(sortedColumn));
            this.table.setSortDirection(sortDirection);
        }
        this.updateTable();
        if (selection) {
            this.setSelection();
        }
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public boolean setFocus() {
        return this.table.setFocus();
    }

    public ITableDecorator getTableDecorator() {
        return this.tableDecorator;
    }

    public int getKeySpalte() {
        return this.internalKeySpalte;
    }

    public String[] getSpaltenTitel() {
        return this.internalSpaltenTitel;
    }

    public Menu getMenu() {
        return this.table.getMenu();
    }

    public void setMenu(Menu arg0) {
        this.table.setMenu(arg0);
    }

    public void setSelectionIndices(int[] selection) {
        this.table.setSelection(selection);
    }

    public String getColumnSizeConfig() {
        if (this.internalTableData == null || this.internalTableData.size() == 0) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        boolean flag = false;
        boolean nullFlag = true;
        if (this.table.isDisposed()) {
            return this.columnSizeConfig;
        }
        TableColumn[] tableColumnArray = this.table.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn col = tableColumnArray[n2];
            if (flag) {
                result.append(";");
            } else {
                flag = true;
            }
            result.append(new Integer(col.getWidth()).toString());
            if (col.getWidth() > 0) {
                nullFlag = false;
            }
            ++n2;
        }
        if (nullFlag) {
            return null;
        }
        return result.toString();
    }

    public void setColumnSizeConfig(String columnSizeConfig) {
        this.columnSizeConfig = columnSizeConfig;
        this.updateColumsSize(false);
    }

    public int getColumnCount() {
        if (this.table != null) {
            return this.table.getColumnCount();
        }
        return 0;
    }

    private void updateColumsSize(boolean repaint) {
        if (!this.isSized && this.internalTableData != null && this.internalTableData.size() > 0 || !this.isSized && this.columnSizeConfig != null && this.columnSizeConfig.split("\\;").length == this.internalSpaltenTitel.length) {
            List<String> cols;
            if (repaint) {
                this.isSized = true;
            }
            if (this.columnSizeConfig != null && (cols = Arrays.asList(this.columnSizeConfig.split("\\;"))).size() == this.internalSpaltenTitel.length) {
                this.isSized = true;
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        int i = 0;
                        while (i < SimpleTable.this.internalSpaltenTitel.length) {
                            if (!SimpleTable.this.table.isDisposed()) {
                                SimpleTable.this.table.getColumn(i).setWidth(new Integer((String)cols.get(i)).intValue());
                                if (SimpleTable.this.internalSpaltenTitel[i].equals("#HIDE")) {
                                    SimpleTable.this.table.getColumn(i).setWidth(0);
                                    SimpleTable.this.table.getColumn(i).setResizable(false);
                                }
                            }
                            ++i;
                        }
                    }
                });
                return;
            }
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (SimpleTable.this.columnSizeConfig != null) {
                        return;
                    }
                    SimpleTable.this.table.setRedraw(false);
                    int i = 0;
                    while (i < SimpleTable.this.internalSpaltenTitel.length) {
                        if (!SimpleTable.this.table.isDisposed()) {
                            SimpleTable.this.table.getColumn(i).pack();
                            if (SimpleTable.this.table.getColumn(i).getWidth() > 500) {
                                SimpleTable.this.table.getColumn(i).setWidth(500);
                            }
                            if (SimpleTable.this.internalSpaltenTitel[i].equals("#HIDE")) {
                                SimpleTable.this.table.getColumn(i).setWidth(0);
                                SimpleTable.this.table.getColumn(i).setResizable(false);
                            }
                        }
                        ++i;
                    }
                    SimpleTable.this.table.setRedraw(true);
                }
            });
        }
    }

    public void optimizeColumnSize() {
        this.isSized = false;
        this.setColumnSizeConfig(null);
        this.updateColumsSize(false);
    }

    static String breakText(String text, int maxLength) {
        StringBuilder result = new StringBuilder(text.length() + 10);
        BreakIterator boundary = BreakIterator.getLineInstance();
        boundary.setText(text);
        int start = boundary.first();
        int end = boundary.next();
        int lineLength = 0;
        while (end != -1) {
            String word = text.substring(start, end);
            lineLength += word.length();
            if (word.indexOf("\\n") > 0) {
                lineLength = word.length() - word.indexOf("\\n");
            }
            if (lineLength >= maxLength) {
                result.append("\\n");
                lineLength = word.length();
            }
            result.append(word);
            start = end;
            end = boundary.next();
        }
        return result.toString();
    }
}

