/*
 * Decompiled with CFR 0.152.
 */
package petter.eclipse.documentspy;

import com.ibm.notes.java.api.util.NotesSessionJob;
import java.util.Arrays;
import java.util.Vector;
import lotus.domino.Database;
import lotus.domino.DateTime;
import lotus.domino.Document;
import lotus.domino.Item;
import lotus.domino.NotesException;
import lotus.domino.Session;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import petter.eclipse.documentspy.NItem;
import petter.eclipse.documentspy.StringUtils;

public class SimpleEditItemDialog
extends TitleAreaDialog {
    private Image imageDialog;
    private Text bigTextField;
    private final NItem item;

    public SimpleEditItemDialog(Shell shell, NItem item) {
        super(shell);
        this.item = item;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        if (this.isReadOnly(this.item)) {
            this.setTitle("Sorry, but read only items can not be edited");
            this.setMessage("");
            this.bigTextField.setEditable(false);
        } else {
            this.setMessage("Use \"|\" to split multiple values and use \"\\\" to escape \"|\" in your values.");
            this.setTitle("Edit " + this.item.getName() + " Item");
        }
        if (this.imageDialog == null) {
            this.imageDialog = new Image(null, ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("petter/eclipse/documentspy/images/Lupe64.png"));
        }
        this.setTitleImage(this.imageDialog);
        return contents;
    }

    private boolean isReadOnly(NItem item2) {
        if (item2.getName().startsWith("#")) {
            return true;
        }
        if (item2.getName().equals("$Revisions")) {
            return true;
        }
        return item2.getBaseType() == 4;
    }

    public void setTitleImage(Image image) {
        super.setTitleImage(image);
        this.imageDialog = image;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (!this.isReadOnly(this.item)) {
            this.createButton(parent, 0, "OK", false);
        }
        this.createButton(parent, 1, "cancel", false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite((Composite)super.createDialogArea(parent), 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new FillLayout());
        this.bigTextField = new Text(composite, 64);
        this.bigTextField.setText(StringUtils.join(this.item.getStrings()));
        return parent;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 12) {
            this.close();
            super.buttonPressed(buttonId);
        }
        if (buttonId == 0) {
            final String[] newValues = StringUtils.split(this.bigTextField.getText());
            NotesSessionJob job = new NotesSessionJob("Save changes to the NotesDocument"){

                protected IStatus runInNotesThread(Session session, IProgressMonitor arg1) throws NotesException {
                    try {
                        Database db = session.getDatabase(null, null);
                        db.openByReplicaID(SimpleEditItemDialog.this.item.getServer(), SimpleEditItemDialog.this.item.getDatabase());
                        Document doc = db.getDocumentByUNID(SimpleEditItemDialog.this.item.getDocUNID());
                        Item it = null;
                        switch (SimpleEditItemDialog.this.item.getBaseType()) {
                            case 1: {
                                it = newValues == null || newValues.length == 0 ? doc.replaceItemValue(SimpleEditItemDialog.this.item.getName(), (Object)"") : doc.replaceItemValue(SimpleEditItemDialog.this.item.getName(), new Vector<String>(Arrays.asList(newValues)));
                                if (SimpleEditItemDialog.this.item.getType() == 1076) {
                                    it.setAuthors(true);
                                }
                                if (SimpleEditItemDialog.this.item.getType() == 1074) {
                                    it.setNames(true);
                                }
                                if (SimpleEditItemDialog.this.item.getType() != 1075) break;
                                it.setReaders(true);
                                break;
                            }
                            case 2: {
                                it = null;
                                if (newValues == null || newValues.length == 0) {
                                    it = doc.replaceItemValue(SimpleEditItemDialog.this.item.getName(), null);
                                }
                                Vector<DateTime> dates = new Vector<DateTime>();
                                String[] stringArray = newValues;
                                int n = newValues.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String value = stringArray[n2];
                                    dates.add(session.createDateTime(value));
                                    ++n2;
                                }
                                it = doc.replaceItemValue(SimpleEditItemDialog.this.item.getName(), dates);
                                break;
                            }
                            case 3: {
                                it = null;
                                if (newValues == null || newValues.length == 0) {
                                    it = doc.replaceItemValue(SimpleEditItemDialog.this.item.getName(), null);
                                }
                                Vector<Double> numbers = new Vector<Double>();
                                String[] stringArray = newValues;
                                int n = newValues.length;
                                int n3 = 0;
                                while (n3 < n) {
                                    String value = stringArray[n3];
                                    numbers.add(new Double(value));
                                    ++n3;
                                }
                                it = doc.replaceItemValue(SimpleEditItemDialog.this.item.getName(), numbers);
                                break;
                            }
                        }
                        doc.save(true, false);
                    }
                    catch (Exception e) {
                        final Exception e1 = e;
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                SimpleEditItemDialog.this.setErrorMessage("An error occured during saving your changes: " + e1.getMessage());
                            }
                        });
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
            try {
                job.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (job.getResult() == Status.OK_STATUS) {
                this.close();
                super.buttonPressed(buttonId);
            }
        }
        if (buttonId == 1) {
            this.close();
            super.buttonPressed(buttonId);
        }
    }

    public boolean close() {
        if (this.imageDialog != null) {
            this.imageDialog.dispose();
        }
        return super.close();
    }
}

