/*
 * Decompiled with CFR 0.152.
 */
package petter.eclipse.documentspy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import petter.eclipse.documentspy.Activator;
import petter.eclipse.documentspy.ITableDecorator;
import petter.eclipse.documentspy.SimpleTable;
import petter.eclipse.documentspy.TableData;
import petter.eclipse.documentspy.TableDecorator;

public class SelectionDialog<E>
extends TitleAreaDialog
implements IProgressMonitor {
    private Image imageDialog;
    private TableData data;
    private ITableDecorator tableDecorator;
    private SimpleTable table;
    private String[] titles;
    private String message;
    private String titel;
    private boolean multiSelection;
    private Text suchBegriff;
    private List<E> currentSelection;
    private int argumentColumn;
    private Composite progressComp;
    private ProgressBar progressBar;
    private Label progressBarLabel;
    private Button progressBarButton;
    private boolean abbruch;

    public SelectionDialog(Shell parentShell, TableData data, List<E> currentSelection, boolean multiSelection) {
        this(parentShell, data, new String[]{"Argument", "Bezeichnung"}, "W\u00e4hlen Sie die passenden Werte aus der Liste aus", "Auswahl", currentSelection, multiSelection, 0);
    }

    public SelectionDialog(Shell parentShell, TableData data, String[] titles, String message, String titel, List<E> currentSelection) {
        this(parentShell, data, titles, message, titel, currentSelection, false, 0);
    }

    public SelectionDialog(Shell parentShell, TableData data, String[] titles, String message, String titel, List<E> currentSelection, boolean multiSelection) {
        this(parentShell, data, titles, message, titel, currentSelection, multiSelection, 0);
    }

    public SelectionDialog(Shell parentShell, TableData data, String[] titles, String message, String titel, List<E> currentSelection, boolean multiSelection, int argumentColumn) {
        super(parentShell);
        this.data = data;
        this.multiSelection = multiSelection;
        this.currentSelection = currentSelection;
        this.tableDecorator = new TableDecorator();
        this.titles = titles;
        this.titel = titel;
        this.message = message;
        this.argumentColumn = argumentColumn;
    }

    protected Control createContents(Composite parent) {
        Display.getDefault().timerExec(300, new Runnable(){

            @Override
            public void run() {
                SelectionDialog.this.getShell().forceActive();
            }
        });
        Control contents = super.createContents(parent);
        this.setMessage(this.message);
        this.setTitle(this.titel);
        if (this.imageDialog == null) {
            this.imageDialog = new Image(null, ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("petter/eclipse/documentspy/images/Lupe64.png"));
        }
        this.setTitleImage(this.imageDialog);
        return contents;
    }

    public void setTitleImage(Image image) {
        super.setTitleImage(image);
        this.imageDialog = image;
    }

    public boolean close() {
        if (this.imageDialog != null) {
            this.imageDialog.dispose();
        }
        if (this.table.getSortDirection() != 0) {
            String key = Arrays.asList(this.titles).toString();
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            store.setValue("SelectionDialogSortierungRichtung" + key, this.table.getSortDirection());
            store.setValue("SelectionDialogSortierungSpalte" + key, this.table.getSortColumn());
        }
        return super.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "OK", false);
        this.createButton(parent, 1, "abbrechen", false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 12) {
            this.currentSelection = this.table.getSelection();
            this.close();
            super.buttonPressed(buttonId);
        }
        if (buttonId == 0) {
            this.currentSelection = this.table.getSelection();
            this.close();
            super.buttonPressed(buttonId);
        }
        if (buttonId == 1) {
            this.currentSelection = this.table.getSelection();
            this.close();
            super.buttonPressed(buttonId);
        }
    }

    public List<E> getCurrentSelection() {
        return this.currentSelection;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10 | 0x400);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite filterComp = new Composite(composite, 0);
        GridData layoutData = new GridData(4, 2, true, false);
        filterComp.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = false;
        layout.numColumns = 2;
        filterComp.setLayout((Layout)layout);
        layoutData = new GridData(1, 2, false, false);
        Label filterLabel = new Label(filterComp, 0);
        filterLabel.setText("Filter:");
        filterLabel.setLayoutData((Object)layoutData);
        layoutData = new GridData(4, 2, true, false);
        this.suchBegriff = new Text(filterComp, 2048);
        this.suchBegriff.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                if (4 == event.detail) {
                    event.doit = false;
                    SelectionDialog.this.filter();
                }
            }
        });
        this.suchBegriff.setLayoutData((Object)layoutData);
        this.progressComp = new Composite(composite, 0);
        layoutData = new GridData(4, 1, true, false);
        this.progressComp.setLayoutData((Object)layoutData);
        this.progressComp.setLayout((Layout)new GridLayout(3, false));
        layoutData.exclude = true;
        layoutData = new GridData(4, 4, true, true);
        layoutData.heightHint = 500;
        layoutData.widthHint = 600;
        if (this.data == null) {
            this.data = new TableData();
        }
        this.data.waitTillReady(5000);
        this.table = this.multiSelection ? new SimpleTable(composite, 67586, this.argumentColumn, this.titles, this.data, this.tableDecorator) : new SimpleTable(composite, 67588, this.argumentColumn, this.titles, this.data, this.tableDecorator);
        this.table.setLayoutData(layoutData);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
                SelectionDialog.this.currentSelection = SelectionDialog.this.table.getSelection();
                SelectionDialog.this.close();
            }
        });
        this.table.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent arg0) {
            }

            public void keyPressed(KeyEvent arg0) {
                if (arg0.character >= 'a' && arg0.character <= 'z' || arg0.character >= 'A' && arg0.character <= 'Z' || arg0.character >= '0' && arg0.character <= '9') {
                    SelectionDialog.this.suchBegriff.setFocus();
                    SelectionDialog.this.suchBegriff.insert("" + arg0.character);
                }
            }
        });
        this.table.setFocus();
        if (this.data != null && this.data.size() > 0) {
            String key = Arrays.asList(this.titles).toString();
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            if (store.getInt("SelectionDialogSortierungRichtung" + key) != 0) {
                this.table.sort(store.getInt("SelectionDialogSortierungSpalte" + key), store.getInt("SelectionDialogSortierungRichtung" + key));
            }
            if (this.currentSelection == null || this.currentSelection.size() == 0) {
                this.currentSelection = new ArrayList();
                this.currentSelection.add(this.data.getObject(0, this.argumentColumn));
            }
            this.table.setSelection(this.currentSelection);
        }
        return composite;
    }

    public void setTableDecorator(ITableDecorator tableDecorator) {
        this.tableDecorator = tableDecorator;
        if (this.table != null && !this.table.isDisposed()) {
            this.table.setTableDecorator(tableDecorator);
        }
    }

    protected void filter() {
        this.currentSelection = this.table.getSelection();
        if (!this.suchBegriff.getText().trim().equals("")) {
            this.data.setFilterList(Arrays.asList(this.suchBegriff.getText().split("\\s*\\,\\s*")));
        } else {
            this.data.setFilterList(null);
        }
        this.table.setTableData(this.data);
        this.table.setSelection(this.currentSelection);
        this.currentSelection = this.table.getSelection();
        if (this.currentSelection.size() == 0 && this.data.size() > 0) {
            this.currentSelection = new ArrayList();
            this.currentSelection.add(this.data.getObject(0, this.argumentColumn));
            this.table.setSelection(this.currentSelection);
        }
        this.table.setFocus();
    }

    public void beginTask(final String arg0, final int arg1) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (SelectionDialog.this.progressBar != null) {
                    SelectionDialog.this.progressBar.dispose();
                }
                if (SelectionDialog.this.progressBarButton != null) {
                    SelectionDialog.this.progressBarButton.dispose();
                }
                if (SelectionDialog.this.progressBarLabel != null) {
                    SelectionDialog.this.progressBarLabel.dispose();
                }
                SelectionDialog.this.progressComp.setVisible(true);
                SelectionDialog.this.setTaskName(arg0);
                SelectionDialog.this.progressBarLabel = new Label(SelectionDialog.this.progressComp, 0);
                SelectionDialog.this.progressBarLabel.setLayoutData((Object)new GridData(4, 1, false, false));
                if (arg1 == -1) {
                    SelectionDialog.this.progressBar = new ProgressBar(SelectionDialog.this.progressComp, 65794);
                } else {
                    SelectionDialog.this.progressBar = new ProgressBar(SelectionDialog.this.progressComp, 65792);
                    SelectionDialog.this.progressBar.setMaximum(arg1);
                }
                GridData data = new GridData(4, 2, true, false);
                SelectionDialog.this.progressBarButton = new Button(SelectionDialog.this.progressComp, 8);
                SelectionDialog.this.progressBarButton.setText("Suche abbrechen");
                SelectionDialog.this.progressBarButton.setLayoutData((Object)new GridData(1, 1, false, false));
                SelectionDialog.this.progressComp.pack();
                SelectionDialog.this.progressBarButton.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent arg0) {
                    }

                    public void widgetSelected(SelectionEvent arg0) {
                        SelectionDialog.this.setCanceled(true);
                    }
                });
                ((GridData)((SelectionDialog)SelectionDialog.this).progressComp.getLayoutData()).exclude = false;
                SelectionDialog.this.progressComp.getParent().layout(true, true);
                SelectionDialog.this.progressBar.setLayoutData((Object)data);
                SelectionDialog.this.progressComp.getParent().layout(true, true);
                SelectionDialog.this.progressBarButton.setEnabled(true);
                SelectionDialog.this.abbruch = false;
            }
        });
    }

    public void done() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                SelectionDialog.this.progressBarButton.dispose();
                SelectionDialog.this.progressBarLabel.dispose();
                SelectionDialog.this.progressBar.dispose();
                ((GridData)((SelectionDialog)SelectionDialog.this).progressComp.getLayoutData()).exclude = true;
                SelectionDialog.this.progressComp.setVisible(false);
                SelectionDialog.this.progressComp.getParent().layout(true);
                SelectionDialog.this.getParentShell().getDisplay().readAndDispatch();
                if (!SelectionDialog.this.progressBarButton.isDisposed()) {
                    SelectionDialog.this.progressBarButton.setEnabled(false);
                }
                SelectionDialog.this.setTaskName("");
            }
        });
    }

    public void internalWorked(double arg0) {
    }

    public boolean isCanceled() {
        return this.abbruch;
    }

    public void setCanceled(boolean arg0) {
        this.abbruch = arg0;
        if (arg0) {
            this.done();
        }
    }

    public void setTaskName(final String arg0) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!SelectionDialog.this.progressBarLabel.isDisposed()) {
                    SelectionDialog.this.progressBarLabel.setText(arg0);
                    SelectionDialog.this.progressBarLabel.getParent().layout(true);
                }
            }
        });
    }

    public void subTask(String arg0) {
    }

    public void worked(final int arg0) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                SelectionDialog.this.progressBar.setSelection(SelectionDialog.this.progressBar.getSelection() + arg0);
            }
        });
    }
}

