/*
 * Decompiled with CFR 0.152.
 */
package petter.eclipse.documentspy;

import com.ibm.csi.types.DocumentSummary;
import com.ibm.notes.java.api.util.NotesSessionJob;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import lotus.domino.Database;
import lotus.domino.Document;
import lotus.domino.Item;
import lotus.domino.NoteCollection;
import lotus.domino.NotesException;
import lotus.domino.Session;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import petter.eclipse.documentspy.Activator;
import petter.eclipse.documentspy.ITableDataAdvancedFilter;
import petter.eclipse.documentspy.NItem;
import petter.eclipse.documentspy.SelectionDialog;
import petter.eclipse.documentspy.SimpleEditItemDialog;
import petter.eclipse.documentspy.SimplePerspectiveSwitcher;
import petter.eclipse.documentspy.SimpleTable;
import petter.eclipse.documentspy.SnapshotViewer;
import petter.eclipse.documentspy.TableData;
import petter.eclipse.documentspy.TableDecorator;

public class DocViewer
extends ViewPart
implements ISelectionListener {
    public static final String id = "petter.eclipse.docviewer";
    private static final String[] spaltenTitel = new String[]{"#HIDE", "Item", "Type", "Value"};
    private SimpleTable table;
    private Text filter;
    private List<String> felderFilter;
    private String[] document;
    private String[] visibleDocument;
    private boolean autoRefresh = true;
    private IAction deleteProfile;
    private IAction toggleAutoRefresh;
    private IAction snapshot;
    private MenuItem copy;
    private MenuItem filterFieldSelection;
    private MenuItem removeFieldSelection;
    private ITableDataAdvancedFilter advancedFilter = new ITableDataAdvancedFilter(){

        @Override
        public boolean isFiltered(List<Object> zeile) {
            if (DocViewer.this.felderFilter != null && !DocViewer.this.felderFilter.contains(((String)zeile.get(1)).toLowerCase())) {
                return false;
            }
            String filterString = DocViewer.this.filter.getText().toLowerCase().trim();
            if (!filterString.equals("")) {
                for (Object obj : zeile) {
                    if (obj == null || !obj.toString().toLowerCase().contains(filterString)) continue;
                    return true;
                }
            } else {
                return true;
            }
            return false;
        }
    };
    private volatile String[] processDocument;

    public void createPartControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        this.filter = new Text(comp, 2048);
        GridData data = new GridData(4, 0x1000000, true, false);
        this.filter.setLayoutData((Object)data);
        this.filter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                DocViewer.this.table.getTableData().setAdvancedFilter(DocViewer.this.advancedFilter);
                DocViewer.this.table.setTableData(DocViewer.this.table.getTableData());
            }
        });
        this.table = new SimpleTable(comp, 65538, 0, spaltenTitel, new TableData(), new TableDecorator(){});
        data = new GridData(4, 4, true, true);
        this.table.setLayoutData(data);
        this.table.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent arg0) {
            }

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.stateMask == 262144 && keyEvent.keyCode == 99) {
                    DocViewer.this.copyClipboard();
                }
            }
        });
        Menu popupMenu = new Menu((Control)this.table);
        this.copy = new MenuItem(popupMenu, 0);
        this.copy.setText("copy");
        this.copy.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DocViewer.this.copyClipboard();
            }
        });
        this.filterFieldSelection = new MenuItem(popupMenu, 0);
        this.filterFieldSelection.setText("Show only selected Fields");
        this.filterFieldSelection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DocViewer.this.felderFilter = new ArrayList();
                TableData data = DocViewer.this.table.getTableData();
                int[] nArray = DocViewer.this.table.getSelectionIndices();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int row = nArray[n2];
                    DocViewer.this.felderFilter.add(((String)data.getObject(row, 1)).toLowerCase());
                    ++n2;
                }
                data.setAdvancedFilter(DocViewer.this.advancedFilter);
                DocViewer.this.table.setTableData(data);
                DocViewer.this.removeFieldSelection.setEnabled(true);
            }
        });
        this.removeFieldSelection = new MenuItem(popupMenu, 0);
        this.removeFieldSelection.setText("Show all Fields");
        this.removeFieldSelection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DocViewer.this.felderFilter = null;
                TableData data = DocViewer.this.table.getTableData();
                data.setAdvancedFilter(DocViewer.this.advancedFilter);
                DocViewer.this.table.setTableData(data);
                DocViewer.this.removeFieldSelection.setEnabled(false);
            }
        });
        this.removeFieldSelection.setEnabled(false);
        this.table.setMenu(popupMenu);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
                if (DocViewer.this.table.getSelection().size() == 0) {
                    return;
                }
                SimpleEditItemDialog dialog = new SimpleEditItemDialog(DocViewer.this.table.getShell(), (NItem)DocViewer.this.table.getSelection().get(0));
                if (dialog.open() == 0 && DocViewer.this.visibleDocument == null) {
                    return;
                }
                DocViewer.this.updateDocument(DocViewer.this.visibleDocument);
            }

            public void widgetSelected(SelectionEvent arg0) {
            }
        });
        this.createActions();
        ISelectionService service = this.getSite().getWorkbenchWindow().getSelectionService();
        service.addPostSelectionListener((ISelectionListener)this);
    }

    private void createActions() {
        IToolBarManager toolbar = this.getViewSite().getActionBars().getToolBarManager();
        IMenuManager menu = this.getViewSite().getActionBars().getMenuManager();
        Action openProfileDocument = new Action(){

            public void run() {
                DocViewer.this.autoRefresh = false;
                DocViewer.this.toggleAutoRefresh.setImageDescriptor(ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"/petter/eclipse/documentspy/images/manrefresh.png"));
                DocViewer.this.toggleAutoRefresh.setText("enable auto refresh");
                DocViewer.this.toggleAutoRefresh.setToolTipText("enable auto refresh");
                NotesSessionJob job = new NotesSessionJob("List Profile Documents"){

                    protected IStatus runInNotesThread(Session session, IProgressMonitor monitor) throws NotesException {
                        if (DocViewer.this.visibleDocument == null) {
                            return Status.OK_STATUS;
                        }
                        monitor.beginTask("List Profile Documents", -1);
                        String server = "";
                        try {
                            server = URLDecoder.decode(DocViewer.this.visibleDocument[0], "UTF-8");
                        }
                        catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                            return Status.OK_STATUS;
                        }
                        Database db = session.getDatabase(null, null);
                        db.openByReplicaID(server, DocViewer.this.visibleDocument[1]);
                        NoteCollection nc = db.createNoteCollection(false);
                        nc.setSelectProfiles(true);
                        nc.buildCollection();
                        String noteID = nc.getFirstNoteID();
                        final TableData data = new TableData();
                        int row = 0;
                        while (noteID != null && !noteID.equals("")) {
                            Document doc = db.getDocumentByID(noteID);
                            int col = 0;
                            try {
                                data.setObject(row, col++, String.valueOf(URLEncoder.encode(server, "UTF-8")) + "/" + DocViewer.this.visibleDocument[1] + "/ /" + doc.getUniversalID());
                            }
                            catch (UnsupportedEncodingException e) {
                                e.printStackTrace();
                            }
                            data.setObject(row, col++, doc.getNameOfProfile());
                            data.setObject(row, col++, doc.getKey());
                            ++row;
                            doc.recycle();
                            noteID = nc.getNextNoteID(noteID);
                        }
                        nc.recycle();
                        db.recycle();
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                SelectionDialog dialog = new SelectionDialog(DocViewer.this.table.getShell(), data, new String[]{"#HIDE", "Profile", "Key"}, "Please choose the profile document you want to view in the document spy", "Profile selection", null, false);
                                if (dialog.open() == 0 && dialog.getCurrentSelection().size() > 0) {
                                    DocViewer.this.document = ((String)dialog.getCurrentSelection().get(0)).split("/", -1);
                                    DocViewer.this.updateDocument(DocViewer.this.document);
                                }
                            }
                        });
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        };
        openProfileDocument.setText("Open Profile document");
        openProfileDocument.setToolTipText("Open Profile document");
        openProfileDocument.setImageDescriptor(ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"/petter/eclipse/documentspy/images/profile.png"));
        toolbar.add((IAction)openProfileDocument);
        menu.add((IAction)openProfileDocument);
        this.toggleAutoRefresh = new Action(){

            public void run() {
                if (DocViewer.this.autoRefresh) {
                    DocViewer.this.autoRefresh = false;
                    this.setImageDescriptor(ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"/petter/eclipse/documentspy/images/manrefresh.png"));
                    this.setText("enable auto refresh");
                    this.setToolTipText("enable auto refresh");
                } else {
                    DocViewer.this.autoRefresh = true;
                    this.setImageDescriptor(ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"/petter/eclipse/documentspy/images/autorefresh.png"));
                    this.setText("disable auto refresh");
                    this.setToolTipText("disable auto refresh");
                }
            }
        };
        this.toggleAutoRefresh.setImageDescriptor(ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"/petter/eclipse/documentspy/images/autorefresh.png"));
        this.toggleAutoRefresh.setText("disable auto refresh");
        this.toggleAutoRefresh.setToolTipText("disable auto refresh");
        toolbar.add(this.toggleAutoRefresh);
        menu.add(this.toggleAutoRefresh);
        Action refresh = new Action(){

            public void run() {
                if (DocViewer.this.document == null) {
                    return;
                }
                DocViewer.this.updateDocument(DocViewer.this.document);
            }
        };
        refresh.setText("refresh Document");
        refresh.setToolTipText("refresh Document");
        refresh.setImageDescriptor(ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"/petter/eclipse/documentspy/images/refresh.png"));
        toolbar.add((IAction)refresh);
        menu.add((IAction)refresh);
        this.deleteProfile = new Action(){

            public void run() {
                if (DocViewer.this.visibleDocument == null) {
                    return;
                }
                MessageBox box = new MessageBox(DocViewer.this.table.getShell(), 196);
                box.setMessage("Do you really want to delete the profile document");
                box.setText("Delete profile document");
                if (box.open() == 64) {
                    NotesSessionJob job = new NotesSessionJob("Delete Profile Document"){

                        protected IStatus runInNotesThread(Session session, IProgressMonitor arg1) throws NotesException {
                            String server = "";
                            try {
                                server = URLDecoder.decode(DocViewer.this.visibleDocument[0], "UTF-8");
                            }
                            catch (UnsupportedEncodingException e) {
                                e.printStackTrace();
                                return Status.OK_STATUS;
                            }
                            Database db = session.getDatabase(null, null);
                            db.openByReplicaID(server, DocViewer.this.visibleDocument[1]);
                            Document doc = db.getDocumentByUNID(DocViewer.this.visibleDocument[3]);
                            doc.remove(true);
                            doc.recycle();
                            db.recycle();
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    DocViewer.this.updateDocument(null);
                                }
                            });
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                }
            }
        };
        this.deleteProfile.setText("Delete Profiledocument");
        this.deleteProfile.setToolTipText("Delete Profiledocument");
        this.deleteProfile.setImageDescriptor(ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"/petter/eclipse/documentspy/images/deleteprofile.png"));
        this.deleteProfile.setEnabled(false);
        toolbar.add(this.deleteProfile);
        menu.add(this.deleteProfile);
        this.snapshot = new Action(){

            public void run() {
                try {
                    SnapshotViewer viewer = (SnapshotViewer)((Object)SimplePerspectiveSwitcher.openPerspektive("petter.eclipse.snapshotviewer", Activator.getDefault().getUniqueViewId(), "Snapshot", false));
                    viewer.initialize(DocViewer.this.table.getTableData(), DocViewer.this.visibleDocument[0], DocViewer.this.visibleDocument[1], DocViewer.this.visibleDocument[3]);
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        };
        this.snapshot.setText("Create a Snapshot");
        this.snapshot.setToolTipText("Create a snapshot of the current document and analyze future changes");
        this.snapshot.setImageDescriptor(ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"/petter/eclipse/documentspy/images/snapshot.png"));
        this.snapshot.setEnabled(false);
        toolbar.add(this.snapshot);
        menu.add(this.snapshot);
    }

    public void setFocus() {
    }

    public void selectionChanged(IWorkbenchPart sourcepart, ISelection selection) {
        if (sourcepart != this && selection instanceof IStructuredSelection) {
            boolean flag = false;
            for (Object obj : ((IStructuredSelection)selection).toList()) {
                String id = null;
                if (id == null && obj instanceof DocumentSummary) {
                    DocumentSummary summary = (DocumentSummary)obj;
                    id = summary.getUrl();
                }
                if (id == null || id.length() < 9) {
                    return;
                }
                this.document = id.substring(8).split("/", -1);
                flag = true;
                if (this.autoRefresh) {
                    this.updateDocument(this.document);
                }
                if (flag) break;
            }
        }
    }

    private void updateDocument(final String[] properties) {
        if (Arrays.equals(properties, this.processDocument)) {
            return;
        }
        this.processDocument = properties;
        this.deleteProfile.setEnabled(false);
        this.visibleDocument = properties;
        if (properties == null) {
            this.table.setTableData(new TableData());
            return;
        }
        NotesSessionJob job = new NotesSessionJob("Update DocumentSpy"){

            protected IStatus runInNotesThread(Session session, IProgressMonitor monitor) throws NotesException {
                String server = "";
                try {
                    server = URLDecoder.decode(properties[0], "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                    return Status.OK_STATUS;
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                Database db = session.getDatabase(null, null);
                db.openByReplicaID(server, properties[1]);
                Document doc = db.getDocumentByUNID(properties[3]);
                ArrayList<NItem> items = new ArrayList<NItem>();
                items.add(new NItem("#Notes-URL", doc.getNotesURL(), server, properties[1], properties[3]));
                items.add(new NItem("#Note-ID", doc.getNoteID(), server, properties[1], properties[3]));
                items.add(new NItem("#Note-UNID", doc.getUniversalID(), server, properties[1], properties[3]));
                if (doc.isProfile()) {
                    items.add(new NItem("#IsProfile", "True", server, properties[1], properties[3]));
                    items.add(new NItem("#Name of Profile", doc.getNameOfProfile(), server, properties[1], properties[3]));
                    items.add(new NItem("#Key of Profile", doc.getKey(), server, properties[1], properties[3]));
                    DocViewer.this.deleteProfile.setEnabled(true);
                }
                for (Object obj : doc.getItems()) {
                    Item item = (Item)obj;
                    try {
                        Vector values = item.getValues();
                        if (values == null || values.size() == 0) {
                            items.add(new NItem(item.getName(), null, item.getType(), server, properties[1], properties[3]));
                            continue;
                        }
                        items.add(new NItem(item.getName(), values.toArray(), item.getType(), server, properties[1], properties[3]));
                    }
                    catch (NotesException e) {
                        e.printStackTrace();
                        System.out.println("Item: " + item.getName());
                    }
                }
                DocViewer.this.updateSingleTable(items);
                DocViewer.this.processDocument = null;
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    protected void updateSingleTable(List<NItem> items) {
        final TableData result = new TableData();
        int row = 0;
        for (NItem item : items) {
            int column = 0;
            result.setObject(row, column++, item);
            result.setObject(row, column++, item.getName());
            result.setObject(row, column++, item.getFormatedType());
            if (item.getObj() == null || item.getObj().length == 0) {
                result.setObject(row, column++, "");
            } else {
                result.setObject(row, column++, item.getFormatedValue());
            }
            ++row;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                DocViewer.this.snapshot.setEnabled(true);
                result.setAdvancedFilter(DocViewer.this.advancedFilter);
                DocViewer.this.table.setTableData(result);
            }
        });
    }

    public void dispose() {
        super.dispose();
        ISelectionService service = this.getSite().getWorkbenchWindow().getSelectionService();
        service.removePostSelectionListener((ISelectionListener)this);
    }

    private void copyClipboard() {
        Clipboard cb = new Clipboard(this.table.getDisplay());
        String text = ((NItem)this.table.getSelection().get(0)).getFormatedValue();
        TextTransfer textTransfer = TextTransfer.getInstance();
        cb.setContents(new Object[]{text}, new Transfer[]{textTransfer});
    }
}

